/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class OtherName
extends ASN1Object {
    private final ASN1ObjectIdentifier typeID;
    private final ASN1Encodable value;

    public static OtherName getInstance(Object obj) {
        if (obj instanceof OtherName) {
            return (OtherName)obj;
        }
        if (obj != null) {
            return new OtherName(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public OtherName(ASN1ObjectIdentifier typeID, ASN1Encodable value) {
        this.typeID = typeID;
        this.value = value;
    }

    private OtherName(ASN1Sequence seq) {
        this.typeID = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        this.value = ASN1TaggedObject.getInstance(seq.getObjectAt(1)).getObject();
    }

    public ASN1ObjectIdentifier getTypeID() {
        return this.typeID;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.typeID);
        v.add(new DERTaggedObject(true, 0, this.value));
        return new DERSequence(v);
    }
}

